#ifndef LEDTRIG_DVL_GENERIC_H
#define LEDTRIG_DVL_GENERIC_H

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/gpio.h>
#include <linux/interrupt.h>
#include <linux/workqueue.h>
#include <linux/leds.h>
#include <linux/slab.h>
#include <linux/timer.h>

#include "dvlled_mod.h"
#include <linux/version.h>

typedef enum
{
    enableState = 0,
    disableState
} diableLEDStates;

struct led_timer_data {
    int gpio;
    int polarity;
    int on_blink;
    int on_ms;
    int off_ms;
};

struct dvl_generic_trig_data {
	struct led_classdev *led;
    int current_led_blink_state;
    diableLEDStates generalLEDState;
    // table led schemes pointer
    struct led_blink_state*  led_states;
    struct timer_list blinkTimer;
    struct led_timer_data timerdata;
};


//Accessable Datastructures
extern struct led_trigger dvl_generic_trigger;

#endif /* LEDTRIG_DVL_GENERIC_H*/
