/* Operating system support for run-time dynamic linker.  Linux/PPC version.
   Copyright (C) 2009
   Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <bits/kernel-features.h>
#ifdef __ASSUME_DCACHESHAPE_AUXVECT

#include <endian.h>
#include <elf.h>
#include <bits/uClibc_page.h>

static int __dcache_way_size;
static int __shm_align;

/* it couldn't make __getshmlba hidden, because shm.h uses it in a macro */
int __getshmlba(void);

int __getshmlba() {
	return __shm_align;
}

/* Decode the cpu dcache way size from the dcache shape */
#define shape_to_waysize(__shape)	((__shape & ~0xff) / (__shape & 0xf))

/* Get the shmlba from the dcache way size */
#define way_size_to_shmlba(__way_size) \
						(((__way_size) > PAGE_SIZE) ? (__way_size) : PAGE_SIZE)
/* Retrieve arch specific data */

#define DL_PLATFORM_AUXV													   \
  __dcache_way_size = shape_to_waysize(av[AT_L1D_CACHESHAPE].a_un.a_val);	   \
  __shm_align = way_size_to_shmlba(__dcache_way_size);

#endif

#include <libc/misc/elf/dl-support.c>
