/* vi: set sw=4 ts=4: */
/*
 * setregid() for uClibc
 *
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include <sys/syscall.h>
#include <unistd.h>
#include <bits/wordsize.h>
#include <setxid.h>

int setregid(gid_t rgid, gid_t egid)
{
	int result;

#if (__WORDSIZE == 32 && defined(__NR_setregid32)) || __WORDSIZE == 64
# ifdef __NR_setregid32
#  undef __NR_setregid
#  define __NR_setregid __NR_setregid32
# endif

#else

	if (((rgid + 1) > (gid_t) ((__kernel_gid_t) - 1U))
		|| ((egid + 1) > (gid_t) ((__kernel_gid_t) - 1U))) {
		__set_errno(EINVAL);
		return -1;
	}
#endif
	result = INLINE_SETXID_SYSCALL (setregid, 2, rgid, egid);
	return result;
}

libc_hidden_def(setregid)
