/*
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#define __FORCE_GLIBC
#include <features.h>
#include <errno.h>
#include <syscall.h>
#include <sys/socket.h>

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
#include <sysdep-cancel.h>
#include <pthreadP.h>
#else
#define SINGLE_THREAD_P 1
#endif

#include <bits/kernel-features.h>
#include "socketcalls.h"

#if !defined __ASSUME_NOT_MULTIPLEXED_SOCKETFUNCS || \
	defined __UCLIBC_HAS_SOCKETCALLS_COMPATIBILITY__
#include "compat_socketcalls.c"
#endif

#ifdef L_accept
extern __typeof(accept) __libc_accept;
#ifdef __NR_accept
#define __NR___sys_accept  __NR_accept
static
_syscall3(int, __sys_accept, int, call, struct sockaddr *, addr, socklen_t *,addrlen)

GEN_WRAPPER3(static int, accept, int, call, struct sockaddr *, addr,
			socklen_t *, addrlen)

int __libc_accept(int s, struct sockaddr *addr, socklen_t * addrlen)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(accept, s, addr, addrlen);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(accept, s, addr, addrlen);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
#endif
weak_alias(__libc_accept,accept)
libc_hidden_weak(accept)
#endif

#ifdef L_accept4
extern __typeof(accept4) __libc_accept4;
#ifdef __NR_accept4
# define __NR___sys_accept4  __NR_accept4
static
_syscall4(int, __sys_accept4, int, fd, struct sockaddr *, addr, socklen_t *, addrlen, int, flags)

GEN_WRAPPER4(static int, accept4, int, call, struct sockaddr *, addr,
			socklen_t *, addrlen, int, flags)

int __libc_accept4(int fd, struct sockaddr *addr, socklen_t * addrlen, int flags)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(accept4, fd, addr, addrlen, flags);
#ifdef __UCLIBC_HAS_THREADS_NATIVE__
		int oldtype = LIBC_CANCEL_ASYNC ();
		int result = SOCKET_FUNCTION(accept4, fd, addr, addrlen, flags);
		LIBC_CANCEL_RESET (oldtype);
		return result;
#endif
}

weak_alias(__libc_accept4,accept4)
libc_hidden_weak(accept4)
#endif
#endif

#ifdef L_bind
#ifdef __NR_bind
#define __NR___sys_bind __NR_bind
static
_syscall3(int, __sys_bind, int, sockfd, const struct sockaddr *, myaddr, socklen_t, addrlen)

GEN_WRAPPER3(static int, bind, int, sockfd, const struct sockaddr *, myaddr,
			socklen_t, addrlen)

GEN_ALIAS(bind)
#endif
libc_hidden_def(bind)
#endif

#ifdef L_connect
extern __typeof(connect) __libc_connect;
#ifdef __NR_connect
#define __NR___sys_connect __NR_connect
static
_syscall3(int, __sys_connect, int, sockfd, const struct sockaddr *, saddr, socklen_t, addrlen)

GEN_WRAPPER3(static int, connect, int, sockfd, const struct sockaddr *, saddr,
			socklen_t, addrlen)

int __libc_connect(int sockfd, const struct sockaddr *saddr, socklen_t addrlen)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(connect, sockfd, saddr, addrlen);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(connect, sockfd, saddr, addrlen);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}

#endif
weak_alias(__libc_connect,connect)
libc_hidden_weak(connect)
#endif

#ifdef L_getpeername
#ifdef __NR_getpeername
#define __NR___sys_getpeername __NR_getpeername
static
_syscall3(int, __sys_getpeername, int, sockfd, struct sockaddr *, addr, socklen_t *,paddrlen)

GEN_WRAPPER3(static int, getpeername, int, sockfd, struct sockaddr *, addr,
			socklen_t *,paddrlen)

GEN_ALIAS(getpeername)
#endif
#endif

#ifdef L_getsockname
#ifdef __NR_getsockname
#define __NR___sys_getsockname __NR_getsockname
static
_syscall3(int, __sys_getsockname, int, sockfd, struct sockaddr *, addr, socklen_t *,paddrlen)

GEN_WRAPPER3(static int, getsockname, int, sockfd, struct sockaddr *, addr,
			socklen_t *,paddrlen)

GEN_ALIAS(getsockname)
#endif
libc_hidden_def(getsockname)
#endif

#ifdef L_getsockopt
#ifdef __NR_getsockopt
#define __NR___sys_getsockopt __NR_getsockopt
static
_syscall5(int, __sys_getsockopt, int, fd, int, level, int, optname, __ptr_t, optval, socklen_t *, optlen)

GEN_WRAPPER5(static int, getsockopt, int, fd, int, level, int, optname,
			__ptr_t, optval, socklen_t *, optlen)

GEN_ALIAS(getsockopt)
#endif
#endif

#ifdef L_listen
#ifdef __NR_listen
#define __NR___sys_listen __NR_listen
static
_syscall2(int, __sys_listen, int, sockfd, int, backlog)

GEN_WRAPPER2(static int, listen, int, sockfd, int, backlog)

GEN_ALIAS(listen)
#endif
libc_hidden_def(listen)
#endif

#ifdef L_recv
extern __typeof(recv) __libc_recv;
#ifdef __NR_recv
#define __NR___sys_recv __NR_recv
static
_syscall4(ssize_t, __sys_recv, int, sockfd, __ptr_t, buffer, size_t, len,
	int, flags)

GEN_WRAPPER4(static ssize_t, recv, int, sockfd, __ptr_t, buffer, size_t, len,
			int, flags)

ssize_t __libc_recv(int sockfd, __ptr_t buffer, size_t len, int flags)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(recv, sockfd, buffer, len, flags);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(recv, sockfd, buffer, len, flags);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
/* recv, recvfrom added by bir7@leland.stanford.edu */
#elif defined(__NR_recvfrom)
ssize_t __libc_recv(int sockfd, __ptr_t buffer, size_t len, int flags)
{
	return (recvfrom(sockfd, buffer, len, flags, NULL, NULL));
}
#endif
weak_alias(__libc_recv,recv)
libc_hidden_weak(recv)
#endif

#ifdef L_recvfrom
extern __typeof(recvfrom) __libc_recvfrom;
#ifdef __NR_recvfrom
#define __NR___sys_recvfrom __NR_recvfrom
static
_syscall6(ssize_t, __sys_recvfrom, int, sockfd, __ptr_t, buffer, size_t, len,
	int, flags, struct sockaddr *, to, socklen_t *, tolen)

GEN_WRAPPER6(static ssize_t, recvfrom, int, sockfd, __ptr_t, buffer,
			size_t, len, int, flags, struct sockaddr *, to, socklen_t *, tolen)

ssize_t __libc_recvfrom(int sockfd, __ptr_t buffer, size_t len, int flags,
		 struct sockaddr *to, socklen_t * tolen)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(recvfrom, sockfd, buffer, len, flags, to, tolen);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(recvfrom, sockfd, buffer, len, flags, to,
								tolen);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
/* recv, recvfrom added by bir7@leland.stanford.edu */
#endif
weak_alias(__libc_recvfrom,recvfrom)
libc_hidden_weak(recvfrom)
#endif

#ifdef L_recvmsg
extern __typeof(recvmsg) __libc_recvmsg;
#ifdef __NR_recvmsg
#define __NR___sys_recvmsg __NR_recvmsg
static
_syscall3(ssize_t, __sys_recvmsg, int, sockfd, struct msghdr *, msg, int, flags)

GEN_WRAPPER3(static ssize_t, recvmsg, int, sockfd, struct msghdr *, msg,
			int, flags)

ssize_t __libc_recvmsg(int sockfd, struct msghdr *msg, int flags)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(recvmsg, sockfd, msg, flags);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(recvmsg, sockfd, msg, flags);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
#endif
weak_alias(__libc_recvmsg,recvmsg)
libc_hidden_weak(recvmsg)
#endif

#ifdef L_send
extern __typeof(send) __libc_send;
#ifdef __NR_send
#define __NR___sys_send    __NR_send
static
_syscall4(ssize_t, __sys_send, int, sockfd, const void *, buffer, size_t, len, int, flags)

GEN_WRAPPER4(static ssize_t, send, int, sockfd, const void *, buffer,
			size_t, len, int, flags)

ssize_t __libc_send(int sockfd, const void *buffer, size_t len, int flags)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(send, sockfd, buffer, len, flags);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(send, sockfd, buffer, len, flags);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
/* send, sendto added by bir7@leland.stanford.edu */
#elif defined(__NR_sendto)
ssize_t __libc_send(int sockfd, const void *buffer, size_t len, int flags)
{
	return (sendto(sockfd, buffer, len, flags, NULL, 0));
}
#endif
weak_alias(__libc_send,send)
libc_hidden_weak(send)
#endif

#ifdef L_sendmsg
extern __typeof(sendmsg) __libc_sendmsg;
#ifdef __NR_sendmsg
#define __NR___sys_sendmsg __NR_sendmsg
static
_syscall3(ssize_t, __sys_sendmsg, int, sockfd, const struct msghdr *, msg, int, flags)

GEN_WRAPPER3(static ssize_t, sendmsg, int, sockfd, const struct msghdr *, msg,
			int, flags)

ssize_t __libc_sendmsg(int sockfd, const struct msghdr *msg, int flags)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(sendmsg, sockfd, msg, flags);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(sendmsg, sockfd, msg, flags);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
#endif
weak_alias(__libc_sendmsg,sendmsg)
libc_hidden_weak(sendmsg)
#endif

#ifdef L_sendto
extern __typeof(sendto) __libc_sendto;
#ifdef __NR_sendto
#define __NR___sys_sendto  __NR_sendto
static
_syscall6(ssize_t, __sys_sendto, int, sockfd, const void *, buffer,
	size_t, len, int, flags, const struct sockaddr *, to, socklen_t, tolen)

GEN_WRAPPER6(static ssize_t, sendto, int, sockfd, const void *, buffer,
		size_t, len, int, flags, const struct sockaddr *, to, socklen_t, tolen)

ssize_t __libc_sendto(int sockfd, const void *buffer, size_t len, int flags,const struct sockaddr *to, socklen_t tolen)
{
	if (SINGLE_THREAD_P)
		return SOCKET_FUNCTION(sendto, sockfd, buffer, len, flags, to, tolen);

#ifdef __UCLIBC_HAS_THREADS_NATIVE__
	int oldtype = LIBC_CANCEL_ASYNC ();
	int result = SOCKET_FUNCTION(sendto, sockfd, buffer, len, flags, to, tolen);
	LIBC_CANCEL_RESET (oldtype);
	return result;
#endif
}
/* send, sendto added by bir7@leland.stanford.edu */
#endif
weak_alias(__libc_sendto,sendto)
libc_hidden_weak(sendto)
#endif

#ifdef L_setsockopt
#ifdef __NR_setsockopt
#define __NR___sys_setsockopt __NR_setsockopt
static
_syscall5(int, __sys_setsockopt, int, fd, int, level, int, optname, const void *, optval, socklen_t, optlen)

GEN_WRAPPER5(static ssize_t, setsockopt, int, fd, int, level, int, optname,
			const void *, optval, socklen_t, optlen)

GEN_ALIAS(setsockopt)
/* [sg]etsockoptions by bir7@leland.stanford.edu */
#endif
libc_hidden_def(setsockopt)
#endif

#ifdef L_shutdown
#ifdef __NR_shutdown
#define __NR___sys_shutdown __NR_shutdown
static
_syscall2(int, __sys_shutdown, int, sockfd, int, how)

GEN_WRAPPER2(static int, shutdown, int, sockfd, int, how)

GEN_ALIAS(shutdown)
/* shutdown by bir7@leland.stanford.edu */
#endif
#endif

#ifdef L_socket
#ifdef __NR_socket
#define __NR___sys_socket __NR_socket
static
_syscall3(int, __sys_socket, int, family, int, type, int, protocol)

GEN_WRAPPER3(static int, socket, int, family, int, type, int, protocol)

GEN_ALIAS(socket)
#endif
libc_hidden_def(socket)
#endif

#ifdef L_socketpair
#ifdef __NR_socketpair
#define __NR___sys_socketpair __NR_socketpair
static
_syscall4(int, __sys_socketpair, int, family, int, type, int, protocol, int *, sockvec)

GEN_WRAPPER4(static int, socketpair, int, family, int, type, int, protocol,
			int *, sockvec)

GEN_ALIAS(socketpair)
#endif
#endif
