
#include "dvlbutton_mod.h"

#define STD_PIO_INT         254 // Interrupt for all Standalone PIOs; 176 + 64 + 14 (ILC-Offset + External-IRQ-Offset + IRQ14)

#define PIO_BANK0_BASE      0xfd020000
#define PIO_BANK1_BASE      0xfe010000
#define PIO_BLOCK_SIZE      0x00001000
#define PIO_IN              0x00000010
#define PIO_PC0             0x00000020
#define PIO_PC1             0x00000030
#define PIO_PC2             0x00000040
#define PIO_PCOMP           0x00000050
#define PIO_PMASK           0x00000060
#define PIO_SET             0x00000004
#define PIO_CLR             0x00000008

#define PIO_11_7            117

#define REG_OFFSET( base, offset ) \
    ((volatile uint32_t *)((int)(base) + (offset)))

dvlbutton_entry_t global_buttons[] =
{
    { BUTTONNAME_ETHERNET_LINK, TYPE_SWITCH, NO_MULTI_CONNECTION, DVLBUTTON_ETH_LINK_ON, DVLBUTTON_ETH_LINK_OFF, DVLBUTTON_NONE, PIO_11_7, STD_PIO_INT, POL_HA, SENSE_EDGE, 0, 0, 0 },
	{ "", TYPE_NONE, NO_MULTI_CONNECTION, 0, 0, 0, 0, 0, 0, 0, 0 ,0 ,0 }
};

#define GPIO_DIR_OUT 0
#define GPIO_DIR_IN  1

static int dvl_gpio_get_pio( int line, int *block, int *pio, volatile uint32_t **pio_base, uint32_t *bit )
{
    *block = line / 10;
    *pio = line % 10;

    if( *block < 0 || *block > 16 || *pio > 7 )
        return -1;
    
    if( *block > 6 )
        *pio_base = REG_OFFSET( PIO_BANK1_BASE, PIO_BLOCK_SIZE * (*block - 7) );
    else
        *pio_base = REG_OFFSET( PIO_BANK1_BASE, PIO_BLOCK_SIZE * *block );

    *bit = 1UL << *pio;

    return 0;
}

static void dvl_gpio_line_config(int line, int direction)
{
    volatile uint32_t *pio_base;
    uint32_t bit;
    int pio, block;

    if( dvl_gpio_get_pio( line, &block, &pio, &pio_base, &bit ) != 0 )
        return;

    if( direction == GPIO_DIR_OUT ) {
        *REG_OFFSET( pio_base, PIO_PC0 | PIO_CLR ) = bit;
        *REG_OFFSET( pio_base, PIO_PC1 | PIO_SET ) = bit;
        *REG_OFFSET( pio_base, PIO_PC2 | PIO_CLR ) = bit;
    } else if( direction == GPIO_DIR_IN ) {
        *REG_OFFSET( pio_base, PIO_PC0 | PIO_CLR ) = bit;
        *REG_OFFSET( pio_base, PIO_PC1 | PIO_CLR ) = bit;
        *REG_OFFSET( pio_base, PIO_PC2 | PIO_CLR ) = bit;
        *REG_OFFSET( pio_base, PIO_PCOMP | PIO_CLR ) = bit;
        *REG_OFFSET( pio_base, PIO_PMASK | PIO_SET ) = bit;
    }
}

void dvl_gpio_line_get(int line, int *value)
{
    volatile uint32_t *pio_base;
    uint32_t bit;
    int pio, block;

    if( dvl_gpio_get_pio( line, &block, &pio, &pio_base, &bit ) != 0 )
        return;

    *value = (*REG_OFFSET( pio_base, PIO_IN ) >> pio) & 1UL;
}

#if 0
void dvl_gpio_line_set(int line, int value)
{
}
#endif

//
//
//

void dvl_gpio_line_config_in(dvlbutton_entry_t *button)
{
	dvl_gpio_line_config(button->gpio, GPIO_DIR_IN);
}

void dvl_gpio_change_get( int irq, int *button, int *change )
{
    dvlbutton_entry_t *b;
    unsigned int i;

    for( b = global_buttons, i = 0; b->type != TYPE_NONE; b++, i++ ) {
        if( b->irq == irq ) {
            volatile uint32_t *pio_base;
            uint32_t bit, value;
            int pio, block;

            if( dvl_gpio_get_pio( b->gpio, &block, &pio, &pio_base, &bit ) != 0 )
                continue;

            value = (*REG_OFFSET( pio_base, PIO_IN ) >> pio) & 1UL;

            if( value != global_contexts[ i ].last_change ) {
                *change = value;
                *button = i;
                return;
            }
        }
    }

    *change = -1;
    *button = -1;
}

void dvl_gpio_clear(void)
{
    dvlbutton_entry_t *b;
    unsigned int i;

    for( b = global_buttons, i = 0; b->type != TYPE_NONE; b++, i++ ) {
        volatile uint32_t *pio_base;
        uint32_t bit;
        int pio, block;

        if( dvl_gpio_get_pio( b->gpio, &block, &pio, &pio_base, &bit ) != 0 )
            continue;

        if( ((*REG_OFFSET( pio_base, PIO_IN ) >> pio) & 1UL) == 1UL )
            *REG_OFFSET( pio_base, PIO_PCOMP | PIO_SET ) = bit;
        else
            *REG_OFFSET( pio_base, PIO_PCOMP | PIO_CLR ) = bit;
    }
}

void dvl_gpio_init(void)
{
    // nothing to do
}


void dvl_gpio_shutdown(void)
{
    dvlbutton_entry_t *b;

    for( b = global_buttons; b->type != TYPE_NONE; b++ ) {
        volatile uint32_t *pio_base;
        uint32_t bit;
        int pio, block;

        if( dvl_gpio_get_pio( b->gpio, &block, &pio, &pio_base, &bit ) != 0 )
            continue;

        *REG_OFFSET( pio_base, PIO_PMASK | PIO_CLR ) = bit;
    }
}
