
/* --------------------------------------------------------------------
 * lpm.h
 * --------------------------------------------------------------------
 *
 *  Copyright (C) 2010 : STMicroelectronics
 *  Author: Pooja Agrawal <pooja.agrwal@st.com>
 *
 * May be copied or modified under the terms of the GNU General Public
 * License version 2.0 ONLY.  See linux/COPYING for more information.
 *
 */


/*
* stlpm_lpmstate_t
*
* Define state of LPM software
*/
enum stlpm_lpmstate{
        STLPM_FW_BOOT=1<<0,
        STLPM_FW_RUNNING=1<<1,
        STLPM_FW_STANDBY=1<<2
};

/*
* stlpm_wakeupdevices
*
* Define wakeup devices
*/
enum stlpm_wakeupdevices{
        STLPM_WAKEUP_IR=1<<0,
        STLPM_WAKEUP_CEC=1<<1,
        STLPM_WAKEUP_FRP=1<<2,
        STLPM_WAKEUP_WOL=1<<3,
        STLPM_WAKEUP_RTC=1<<4,
        STLPM_WAKEUP_ASC=1<<5,
        STLPM_WAKEUP_NMI=1<<6,
        STLPM_WAKEUP_HPD=1<<7
};

/*
* stlpm_time
*
* Defines the time structure used in STLPM driver
*/
struct stlpm_time{
        unsigned int hours;
        char mins;
        char secs;
};

/*
* stlpm_version
*
* Defines the version information of STLPM
*/
struct stlpm_version{
        char majorCommProtocol;
        char minorCommProtocol;
        char majorSoft;
        char minorSoft;
        char patchSoft;
        char month;
        char day;
        char year;
};


/*
* stlpm_wakeupdata
*
* Defines wakeup data
*/
union stlpm_wakeupdata{
        struct stlpm_time wakeuptime;
};

int stlpm_configure_wdt(int timeInMs);

//int stlpm_enterpassivestandby(void);

int stlpm_exitpassivestandby(void);

int stlpm_getFWState(enum stlpm_lpmstate *FWState);

int stlpm_getwakeup_info(enum stlpm_wakeupdevices *wakeupdevice, int *validsize, int *data);

int stlpm_getversion(struct stlpm_version * DriverVersion, struct stlpm_version * FWVersion);

int stlpm_reset(void);

int stlpm_sbcstandby (char SBCStandby);

int stlpm_setRTC(struct stlpm_time *newRTC);

int stlpm_setwakeup_device(enum stlpm_wakeupdevices deviceId, union stlpm_wakeupdata devicedata);

int stlpm_trim_rtc(void);

