/*
 * Copyright (C) STMicroelectronics Ltd. 2008.
 *
 * All rights reserved.
 */

/*
 * This is derived from STMicroelectronics gnu toolchain example:
 *   sh-superh-elf/examples/bare/sh4reg/sti7111reg.h
 */


#ifndef __STX7111REG_H
#define __STX7111REG_H

#include "sh4regtype.h"

/*----------------------------------------------------------------------------*/

/*
 * Peripheral versions
 */

#ifndef ST40_LMIGP_VERSION
#define ST40_LMIGP_VERSION 1
#endif
#ifndef ST40_NAND_CONTROLLER_VERSION
#define ST40_NAND_CONTROLLER_VERSION 1
#endif

/*----------------------------------------------------------------------------*/

/*
 * Base addresses for control register banks.
 */

/* Generic SH4 control registers */
#ifndef SH4_TMU_REGS_BASE
#define SH4_TMU_REGS_BASE 0xffd80000
#endif

/* Common ST40 control registers */
#ifndef ST40_CPG_REGS_BASE
#define ST40_CPG_REGS_BASE 0xffc00000
#endif
#ifndef ST40_INTC_REGS_BASE
#define ST40_INTC_REGS_BASE 0xffd00000
#endif
#ifndef ST40_SCIF2_REGS_BASE
#define ST40_SCIF2_REGS_BASE 0xffe80000
#endif

#ifndef STX7111_COMMS_BASE
#define STX7111_COMMS_BASE 0xfd000000
#endif

#ifndef ST40_ILC_REGS_BASE
#define ST40_ILC_REGS_BASE STX7111_COMMS_BASE
#endif

/* STx7111 control registers */
#ifndef STX7111_SYSCONF_REGS_BASE
#define STX7111_SYSCONF_REGS_BASE 0xfe001000
#endif

#ifndef STX7111_CLOCKGENA_REGS_BASE
#define STX7111_CLOCKGENA_REGS_BASE 0xfe213000
#endif

#ifndef STX7111_CLOCKGENB_REGS_BASE
#define STX7111_CLOCKGENB_REGS_BASE 0xfe000000
#endif

/* System Architecture Volume 2: Bus Interfaces */
#ifndef ST40_LMI_REGS_BASE
#define ST40_LMI_REGS_BASE 0xfe901000
#endif
#ifndef ST40_EMI_REGS_BASE
#define ST40_EMI_REGS_BASE 0xfe700000
#endif

/* System Architecture Volume 4: I/O Devices */
#ifndef ST40_PIO0_REGS_BASE
#define ST40_PIO0_REGS_BASE (STX7111_COMMS_BASE + 0x00020000)
#endif
#ifndef ST40_PIO1_REGS_BASE
#define ST40_PIO1_REGS_BASE (STX7111_COMMS_BASE + 0x00021000)
#endif
#ifndef ST40_PIO2_REGS_BASE
#define ST40_PIO2_REGS_BASE (STX7111_COMMS_BASE + 0x00022000)
#endif
#ifndef ST40_PIO3_REGS_BASE
#define ST40_PIO3_REGS_BASE (STX7111_COMMS_BASE + 0x00023000)
#endif
#ifndef ST40_PIO4_REGS_BASE
#define ST40_PIO4_REGS_BASE (STX7111_COMMS_BASE + 0x00024000)
#endif
#ifndef ST40_PIO5_REGS_BASE
#define ST40_PIO5_REGS_BASE (STX7111_COMMS_BASE + 0x00025000)
#endif
#ifndef ST40_PIO6_REGS_BASE
#define ST40_PIO6_REGS_BASE (STX7111_COMMS_BASE + 0x00026000)
#endif
#ifndef ST40_ASC0_REGS_BASE
#define ST40_ASC0_REGS_BASE (STX7111_COMMS_BASE + 0x00030000)
#endif
#ifndef ST40_ASC1_REGS_BASE
#define ST40_ASC1_REGS_BASE (STX7111_COMMS_BASE + 0x00031000)
#endif
#ifndef ST40_ASC2_REGS_BASE
#define ST40_ASC2_REGS_BASE (STX7111_COMMS_BASE + 0x00032000)
#endif
#ifndef ST40_ASC3_REGS_BASE
#define ST40_ASC3_REGS_BASE (STX7111_COMMS_BASE + 0x00033000)
#endif
#ifndef ST40_SSC0_REGS_BASE
#define ST40_SSC0_REGS_BASE (STX7111_COMMS_BASE + 0x00040000)
#endif
#ifndef ST40_SSC1_REGS_BASE
#define ST40_SSC1_REGS_BASE (STX7111_COMMS_BASE + 0x00041000)
#endif
#ifndef ST40_SSC2_REGS_BASE
#define ST40_SSC2_REGS_BASE (STX7111_COMMS_BASE + 0x00042000)
#endif
#ifndef ST40_SSC3_REGS_BASE
#define ST40_SSC3_REGS_BASE (STX7111_COMMS_BASE + 0x00043000)
#endif
#ifndef ST40_MAILBOX0_REGS_BASE
#define ST40_MAILBOX0_REGS_BASE 0xfe211000
#endif
#ifndef ST40_MAILBOX1_REGS_BASE
#define ST40_MAILBOX1_REGS_BASE (ST40_MAILBOX0_REGS_BASE + 0x1000)
#endif

/*----------------------------------------------------------------------------*/

#include "st40reg.h"

/*
 * STx7111 control registers
 */

/* Clock Generator control registers (STx7111 variant) */
#define STX7111_CLOCKGENA_PLL0_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x00)
#define STX7111_CLOCKGENA_PLL1_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x04)
#define STX7111_CLOCKGENA_POWER_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x10)
#define STX7111_CLOCKGENA_CLKOPSRC_SWITCH_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x14)
#define STX7111_CLOCKGENA_CLKOPSRC_SWITCH_CFG2	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x24)
#define STX7111_CLOCKGENA_CLKOBS_MUX1_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x30)
#define STX7111_CLOCKGENA_CLKOBS_MUX2_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x48)
#define STX7111_CLOCKGENA_OSC_DIV0_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x800)
#define STX7111_CLOCKGENA_OSC_DIV1_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x804)
#define STX7111_CLOCKGENA_OSC_DIV2_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x808)
#define STX7111_CLOCKGENA_OSC_DIV3_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x80c)
#define STX7111_CLOCKGENA_OSC_DIV4_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x810)
#define STX7111_CLOCKGENA_OSC_DIV5_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x814)
#define STX7111_CLOCKGENA_OSC_DIV6_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x818)
#define STX7111_CLOCKGENA_OSC_DIV7_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x81c)
#define STX7111_CLOCKGENA_OSC_DIV8_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x820)
#define STX7111_CLOCKGENA_OSC_DIV9_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x824)
#define STX7111_CLOCKGENA_OSC_DIV10_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x828)
#define STX7111_CLOCKGENA_OSC_DIV11_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x82c)
#define STX7111_CLOCKGENA_OSC_DIV12_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x830)
#define STX7111_CLOCKGENA_OSC_DIV13_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x834)
#define STX7111_CLOCKGENA_OSC_DIV14_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x838)
#define STX7111_CLOCKGENA_OSC_DIV15_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x83c)
#define STX7111_CLOCKGENA_OSC_DIV16_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x840)
#define STX7111_CLOCKGENA_OSC_DIV17_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x844)
#define STX7111_CLOCKGENA_PLL0HS_DIV0_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x900)
#define STX7111_CLOCKGENA_PLL0HS_DIV1_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x904)
#define STX7111_CLOCKGENA_PLL0HS_DIV2_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x908)
#define STX7111_CLOCKGENA_PLL0HS_DIV3_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0x90c)
#define STX7111_CLOCKGENA_PLL0LS_DIV4_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa10)
#define STX7111_CLOCKGENA_PLL0LS_DIV5_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa14)
#define STX7111_CLOCKGENA_PLL0LS_DIV6_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa18)
#define STX7111_CLOCKGENA_PLL0LS_DIV7_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa1c)
#define STX7111_CLOCKGENA_PLL0LS_DIV8_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa20)
#define STX7111_CLOCKGENA_PLL0LS_DIV9_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa24)
#define STX7111_CLOCKGENA_PLL0LS_DIV10_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa28)
#define STX7111_CLOCKGENA_PLL0LS_DIV11_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa2c)
#define STX7111_CLOCKGENA_PLL0LS_DIV12_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa30)
#define STX7111_CLOCKGENA_PLL0LS_DIV13_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa34)
#define STX7111_CLOCKGENA_PLL0LS_DIV14_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa38)
#define STX7111_CLOCKGENA_PLL0LS_DIV15_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa3c0)
#define STX7111_CLOCKGENA_PLL0LS_DIV16_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa40)
#define STX7111_CLOCKGENA_PLL0LS_DIV17_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xa44)
#define STX7111_CLOCKGENA_PLL1_DIV0_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb00)
#define STX7111_CLOCKGENA_PLL1_DIV1_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb04)
#define STX7111_CLOCKGENA_PLL1_DIV2_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb08)
#define STX7111_CLOCKGENA_PLL1_DIV3_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb0c)
#define STX7111_CLOCKGENA_PLL1_DIV4_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb10)
#define STX7111_CLOCKGENA_PLL1_DIV5_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb14)
#define STX7111_CLOCKGENA_PLL1_DIV6_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb18)
#define STX7111_CLOCKGENA_PLL1_DIV7_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb1c)
#define STX7111_CLOCKGENA_PLL1_DIV8_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb20)
#define STX7111_CLOCKGENA_PLL1_DIV9_CFG		SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb24)
#define STX7111_CLOCKGENA_PLL1_DIV10_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb28)
#define STX7111_CLOCKGENA_PLL1_DIV11_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb2c)
#define STX7111_CLOCKGENA_PLL1_DIV12_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb30)
#define STX7111_CLOCKGENA_PLL1_DIV13_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb34)
#define STX7111_CLOCKGENA_PLL1_DIV14_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb38)
#define STX7111_CLOCKGENA_PLL1_DIV15_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb3c)
#define STX7111_CLOCKGENA_PLL1_DIV16_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb40)
#define STX7111_CLOCKGENA_PLL1_DIV17_CFG	SH4_DWORD_REG(STX7111_CLOCKGENA_REGS_BASE + 0xb44)

#define STX7111_CLOCKGENB_FS0_CTRL		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x14)
#define STX7111_CLOCKGENB_FS0_MD1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x18)
#define STX7111_CLOCKGENB_FS0_PE1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x1c)
#define STX7111_CLOCKGENB_FS0_EN_PRG1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x20)
#define STX7111_CLOCKGENB_FS0_SDIV1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x24)
#define STX7111_CLOCKGENB_FS0_MD2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x28)
#define STX7111_CLOCKGENB_FS0_PE2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x2c)
#define STX7111_CLOCKGENB_FS0_EN_PRG2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x30)
#define STX7111_CLOCKGENB_FS0_SDIV2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x34)
#define STX7111_CLOCKGENB_FS0_MD3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x38)
#define STX7111_CLOCKGENB_FS0_PE3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x3c)
#define STX7111_CLOCKGENB_FS0_EN_PRG3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x40)
#define STX7111_CLOCKGENB_FS0_SDIV3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x44)
#define STX7111_CLOCKGENB_FS0_CLOCKOUT_CTRL	SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x58)
#define STX7111_CLOCKGENB_FS1_CTRL		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x5c)
#define STX7111_CLOCKGENB_FS1_MD1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x60)
#define STX7111_CLOCKGENB_FS1_PE1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x64)
#define STX7111_CLOCKGENB_FS1_EN_PRG1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x68)
#define STX7111_CLOCKGENB_FS1_SDIV1		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x6c)
#define STX7111_CLOCKGENB_FS1_MD2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x70)
#define STX7111_CLOCKGENB_FS1_PE2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x74)
#define STX7111_CLOCKGENB_FS1_EN_PRG2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x78)
#define STX7111_CLOCKGENB_FS1_SDIV2		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x7c)
#define STX7111_CLOCKGENB_FS1_MD3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x80)
#define STX7111_CLOCKGENB_FS1_PE3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x84)
#define STX7111_CLOCKGENB_FS1_EN_PRG3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x88)
#define STX7111_CLOCKGENB_FS1_SDIV3		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x8c)
#define STX7111_CLOCKGENB_FS1_MD4		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x90)
#define STX7111_CLOCKGENB_FS1_PE4		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x94)
#define STX7111_CLOCKGENB_FS1_EN_PRG4		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x98)
#define STX7111_CLOCKGENB_FS1_SDIV4		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0x9c)
#define STX7111_CLOCKGENB_FS1_CLOCKOUT_CTRL	SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xa0)
#define STX7111_CLOCKGENB_DISPLAY_CFG		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xa4)
#define STX7111_CLOCKGENB_FS_SELECT		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xa8)
#define STX7111_CLOCKGENB_POWER_DOWN		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xac)
#define STX7111_CLOCKGENB_POWER_ENABLE		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xb0)
#define STX7111_CLOCKGENB_OUT_CTRL		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xb4)
#define STX7111_CLOCKGENB_CRISTAL_SEL		SH4_DWORD_REG(STX7111_CLOCKGENB_REGS_BASE + 0xb8)

/* System configuration registers (STx7111 variant) */
#define STX7111_SYSCONF_DEVICEID_0		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0000)
#define STX7111_SYSCONF_DEVICEID_1		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0004)
#define STX7111_SYSCONF_DEVICEID		SH4_GWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0000)
#define STX7111_SYSCONF_SYS_STA00		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0008)
#define STX7111_SYSCONF_SYS_STA01		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x000c)
#define STX7111_SYSCONF_SYS_STA02		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0010)
#define STX7111_SYSCONF_SYS_STA03		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0014)
#define STX7111_SYSCONF_SYS_STA04		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0018)
#define STX7111_SYSCONF_SYS_STA05		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x001c)
#define STX7111_SYSCONF_SYS_STA06		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0020)
#define STX7111_SYSCONF_SYS_STA07		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0024)
#define STX7111_SYSCONF_SYS_STA08		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0028)
#define STX7111_SYSCONF_SYS_STA09		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x002c)
#define STX7111_SYSCONF_SYS_STA10		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0030)
#define STX7111_SYSCONF_SYS_STA11		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0034)
#define STX7111_SYSCONF_SYS_STA12		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0038)
#define STX7111_SYSCONF_SYS_STA13		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x003c)
#define STX7111_SYSCONF_SYS_STA14		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0040)
#define STX7111_SYSCONF_SYS_STA15		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0044)
#define STX7111_SYSCONF_SYS_CFG00		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0100)
#define STX7111_SYSCONF_SYS_CFG01		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0104)
#define STX7111_SYSCONF_SYS_CFG02		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0108)
#define STX7111_SYSCONF_SYS_CFG03		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x010c)
#define STX7111_SYSCONF_SYS_CFG04		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0110)
#define STX7111_SYSCONF_SYS_CFG05		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0114)
#define STX7111_SYSCONF_SYS_CFG06		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0118)
#define STX7111_SYSCONF_SYS_CFG07		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x011c)
#define STX7111_SYSCONF_SYS_CFG08		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0120)
#define STX7111_SYSCONF_SYS_CFG09		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0124)
#define STX7111_SYSCONF_SYS_CFG10		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0128)
#define STX7111_SYSCONF_SYS_CFG11		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x012c)
#define STX7111_SYSCONF_SYS_CFG12		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0130)
#define STX7111_SYSCONF_SYS_CFG13		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0134)
#define STX7111_SYSCONF_SYS_CFG14		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0138)
#define STX7111_SYSCONF_SYS_CFG15		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x013c)
#define STX7111_SYSCONF_SYS_CFG16		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0140)
#define STX7111_SYSCONF_SYS_CFG17		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0144)
#define STX7111_SYSCONF_SYS_CFG18		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0148)
#define STX7111_SYSCONF_SYS_CFG19		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x014c)
#define STX7111_SYSCONF_SYS_CFG20		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0150)
#define STX7111_SYSCONF_SYS_CFG21		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0154)
#define STX7111_SYSCONF_SYS_CFG22		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0158)
#define STX7111_SYSCONF_SYS_CFG23		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x015c)
#define STX7111_SYSCONF_SYS_CFG24		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0160)
#define STX7111_SYSCONF_SYS_CFG25		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0164)
#define STX7111_SYSCONF_SYS_CFG26		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0168)
#define STX7111_SYSCONF_SYS_CFG27		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x016c)
#define STX7111_SYSCONF_SYS_CFG28		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0170)
#define STX7111_SYSCONF_SYS_CFG29		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0174)
#define STX7111_SYSCONF_SYS_CFG30		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0178)
#define STX7111_SYSCONF_SYS_CFG31		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x017c)
#define STX7111_SYSCONF_SYS_CFG32		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0180)
#define STX7111_SYSCONF_SYS_CFG33		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0184)
#define STX7111_SYSCONF_SYS_CFG34		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0188)
#define STX7111_SYSCONF_SYS_CFG35		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x018c)
#define STX7111_SYSCONF_SYS_CFG36		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0190)
#define STX7111_SYSCONF_SYS_CFG37		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0194)
#define STX7111_SYSCONF_SYS_CFG38		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x0198)
#define STX7111_SYSCONF_SYS_CFG39		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x019c)
#define STX7111_SYSCONF_SYS_CFG40		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01a0)
#define STX7111_SYSCONF_SYS_CFG41		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01a4)
#define STX7111_SYSCONF_SYS_CFG42		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01a8)
#define STX7111_SYSCONF_SYS_CFG43		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01ac)
#define STX7111_SYSCONF_SYS_CFG44		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01b0)
#define STX7111_SYSCONF_SYS_CFG45		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01b4)
#define STX7111_SYSCONF_SYS_CFG46		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01b8)
#define STX7111_SYSCONF_SYS_CFG47		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01bc)
#define STX7111_SYSCONF_SYS_CFG48		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01c0)
#define STX7111_SYSCONF_SYS_CFG49		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01c4)
#define STX7111_SYSCONF_SYS_CFG50		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01c8)
#define STX7111_SYSCONF_SYS_CFG51		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01cc)
#define STX7111_SYSCONF_SYS_CFG52		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01d0)
#define STX7111_SYSCONF_SYS_CFG53		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01d4)
#define STX7111_SYSCONF_SYS_CFG54		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01d8)
#define STX7111_SYSCONF_SYS_CFG55		SH4_DWORD_REG(STX7111_SYSCONF_REGS_BASE + 0x01dc)

/* Device ID values, masks & predicates */
#define STX7111_DEVID_7111_VAL		0x03B
#define STX7111_DEVID_ID_SHIFT		12
#define STX7111_DEVID_ID_MASK		0x3ff
#define STX7111_DEVID_CUT_SHIFT		28
#define STX7111_DEVID_CUT_MASK		0xf

#define STX7111_DEVICEID_7111(ID) ((((ID) >> STX7111_DEVID_ID_SHIFT) & STX7111_DEVID_ID_MASK) == STX7111_DEVID_7111_VAL)
#define STX7111_DEVICEID_CUT(ID)  ((((ID) >> STX7111_DEVID_CUT_SHIFT) & STX7111_DEVID_CUT_MASK) + 1)

#endif /* __STX7111REG_H */
