/*
 * Copyright (C) STMicroelectronics Ltd. 2005.
 *
 * All rights reserved.
 */

#ifndef __STB7100REG_H
#define __STB7100REG_H

#include "asm/sh4regtype.h"

/*----------------------------------------------------------------------------*/

/*
 * Peripheral versions
 */

#ifndef ST40_LMI_VERSION
#define ST40_LMI_VERSION 3
#endif

/*----------------------------------------------------------------------------*/

/*
 * Base addresses for control register banks
 */

/* Generic SH4 control registers */
#ifndef SH4_TMU_REGS_BASE
#define SH4_TMU_REGS_BASE 0xffd80000
#endif
#ifndef SH4_RTC_REGS_BASE
#define SH4_RTC_REGS_BASE 0xffc80000
#endif

/* Common ST40 control registers */
#ifndef ST40_CPG_REGS_BASE
#define ST40_CPG_REGS_BASE 0xffc00000
#endif
#ifndef ST40_INTC_REGS_BASE
#define ST40_INTC_REGS_BASE 0xffd00000
#endif
#ifndef ST40_INTC2_REGS_BASE
#define ST40_INTC2_REGS_BASE 0xfe080000
#endif
#ifndef ST40_SCIF1_REGS_BASE
#define ST40_SCIF1_REGS_BASE 0xffe00000
#endif
#ifndef ST40_SCIF2_REGS_BASE
#define ST40_SCIF2_REGS_BASE 0xffe80000
#endif

/* STb7100 control registers */
#ifndef STB7100_SYSCONF_REGS_BASE
#define STB7100_SYSCONF_REGS_BASE 0xb9001000
#endif

#ifndef STB7100_CLOCKGENA_REGS_BASE
#define STB7100_CLOCKGENA_REGS_BASE 0xb9213000
#endif

/* System Architecture Volume 2: Bus Interfaces */
#ifndef ST40_LMISYS_REGS_BASE
#define ST40_LMISYS_REGS_BASE 0xaf000000
#endif
#ifndef ST40_LMIVID_REGS_BASE
#define ST40_LMIVID_REGS_BASE 0xb7000000
#endif
#ifndef ST40_EMI_REGS_BASE
#define ST40_EMI_REGS_BASE 0xba100000
#endif

/*----------------------------------------------------------------------------*/

#include "asm/st40reg.h"

/*
 * STb7100 control registers
 */

/* Clock Generator control registers (STb7100 variant) */
#define STB7100_CLOCKGENA_LOCK			SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x00)
#define STB7100_CLOCKGENA_MD_STATUS		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x04)
#define STB7100_CLOCKGENA_PLL0_CFG		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x08)
#define STB7100_CLOCKGENA_PLL0_STATUS		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x10)
#define STB7100_CLOCKGENA_PLL0_CLK1_CTRL	SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x14)
#define STB7100_CLOCKGENA_PLL0_CLK2_CTRL	SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x18)
#define STB7100_CLOCKGENA_PLL0_CLK3_CTRL	SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x1c)
#define STB7100_CLOCKGENA_PLL0_CLK4_CTRL	SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x20)
#define STB7100_CLOCKGENA_PLL1_CFG		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x24)
#define STB7100_CLOCKGENA_PLL1_STATUS		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x2c)
#define STB7100_CLOCKGENA_CLK_DIV		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x30)
#define STB7100_CLOCKGENA_CLOCK_ENABLE		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x34)
#define STB7100_CLOCKGENA_OUT_CTRL		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x38)
#define STB7100_CLOCKGENA_PLL1_BYPASS		SH4_DWORD_REG(STB7100_CLOCKGENA_REGS_BASE + 0x3c)

/* System configuration registers (STb7100 variant) */
#if defined(ST40_LITTLE_ENDIAN)
#define STB7100_SYSCONF_DEVICEID_0	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0000)
#define STB7100_SYSCONF_DEVICEID_1	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0004)
#define STB7100_SYSCONF_DEVICEID	STB7100_SYSCONF_DEVICEID_0
#elif defined(ST40_BIG_ENDIAN)
#define STB7100_SYSCONF_DEVICEID_0	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0004)
#define STB7100_SYSCONF_DEVICEID_1	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0000)
#define STB7100_SYSCONF_DEVICEID	STB7100_SYSCONF_DEVICEID_0
#else
#error ST40_LITTLE_ENDIAN and ST40_BIG_ENDIAN undefined
#endif
#define STB7100_SYSCONF_SYS_STA00	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0008)
#define STB7100_SYSCONF_SYS_STA01	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x000c)
#define STB7100_SYSCONF_SYS_STA02	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0010)
#define STB7100_SYSCONF_SYS_STA03	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0014)
#define STB7100_SYSCONF_SYS_STA04	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0018)
#define STB7100_SYSCONF_SYS_STA05	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x001c)
#define STB7100_SYSCONF_SYS_STA06	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0020)
#define STB7100_SYSCONF_SYS_STA07	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0024)
#define STB7100_SYSCONF_SYS_STA08	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0028)
#define STB7100_SYSCONF_SYS_STA09	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x002c)
#define STB7100_SYSCONF_SYS_STA10	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0030)
#define STB7100_SYSCONF_SYS_STA11	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0034)
#define STB7100_SYSCONF_SYS_STA12	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0038)
#define STB7100_SYSCONF_SYS_STA13	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x003c)
#define STB7100_SYSCONF_SYS_STA14	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0040)
#define STB7100_SYSCONF_SYS_CFG00	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0100)
#define STB7100_SYSCONF_SYS_CFG01	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0104)
#define STB7100_SYSCONF_SYS_CFG02	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0108)
#define STB7100_SYSCONF_SYS_CFG03	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x010c)
#define STB7100_SYSCONF_SYS_CFG04	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0110)
#define STB7100_SYSCONF_SYS_CFG05	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0114)
#define STB7100_SYSCONF_SYS_CFG06	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0118)
#define STB7100_SYSCONF_SYS_CFG07	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x011c)
#define STB7100_SYSCONF_SYS_CFG08	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0120)
#define STB7100_SYSCONF_SYS_CFG09	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0124)
#define STB7100_SYSCONF_SYS_CFG10	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0128)
#define STB7100_SYSCONF_SYS_CFG11	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x012c)
#define STB7100_SYSCONF_SYS_CFG12	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0130)
#define STB7100_SYSCONF_SYS_CFG13	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0134)
#define STB7100_SYSCONF_SYS_CFG14	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0138)
#define STB7100_SYSCONF_SYS_CFG15	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x013c)
#define STB7100_SYSCONF_SYS_CFG16	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0140)
#define STB7100_SYSCONF_SYS_CFG17	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0144)
#define STB7100_SYSCONF_SYS_CFG18	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0148)
#define STB7100_SYSCONF_SYS_CFG19	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x014c)
#define STB7100_SYSCONF_SYS_CFG20	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0150)
#define STB7100_SYSCONF_SYS_CFG21	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0154)
#define STB7100_SYSCONF_SYS_CFG22	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0158)
#define STB7100_SYSCONF_SYS_CFG23	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x015c)
#define STB7100_SYSCONF_SYS_CFG24	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0160)
#define STB7100_SYSCONF_SYS_CFG25	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0164)
#define STB7100_SYSCONF_SYS_CFG26	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0168)
#define STB7100_SYSCONF_SYS_CFG27	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x016c)
#define STB7100_SYSCONF_SYS_CFG28	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0170)
#define STB7100_SYSCONF_SYS_CFG29	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0174)
#define STB7100_SYSCONF_SYS_CFG30	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0178)
#define STB7100_SYSCONF_SYS_CFG31	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x017c)
#define STB7100_SYSCONF_SYS_CFG32	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0180)
#define STB7100_SYSCONF_SYS_CFG33	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0184)
#define STB7100_SYSCONF_SYS_CFG34	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0188)
#define STB7100_SYSCONF_SYS_CFG35	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x018c)
#define STB7100_SYSCONF_SYS_CFG36	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0190)
#define STB7100_SYSCONF_SYS_CFG37	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0194)
#define STB7100_SYSCONF_SYS_CFG38	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x0198)
#define STB7100_SYSCONF_SYS_CFG39	SH4_DWORD_REG(STB7100_SYSCONF_REGS_BASE + 0x019c)

#define STB7100_DEVID_7100_VAL		0x024
#define STB7100_DEVID_7109_VAL		0x02c
#define STB7100_DEVID_ID_SHIFT		12
#define STB7100_DEVID_ID_MASK		0x3ff
#define STB7100_DEVID_CUT_SHIFT		28
#define STB7100_DEVID_CUT_MASK		0xf

#define STB7100_DEVICEID_7100(ID) ((((ID) >> STB7100_DEVID_ID_SHIFT) & STB7100_DEVID_ID_MASK) == STB7100_DEVID_7100_VAL)
#define STB7100_DEVICEID_7109(ID) ((((ID) >> STB7100_DEVID_ID_SHIFT) & STB7100_DEVID_ID_MASK) == STB7100_DEVID_7109_VAL)
#define STB7100_DEVICEID_CUT(ID)  ((((ID) >> STB7100_DEVID_CUT_SHIFT) & STB7100_DEVID_CUT_MASK) + 1)

#endif /* __STB7100REG_H */
