/*
 * The poke table is a series of long words, in the format
 *
 *	opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#undef CONFIG_SH_OLD_POKE_LOOP_PARADIGM


#include "asm/stx7108reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:

	/*
	 * include the appropriate set of "GDB pokes", (usually) generated
	 * using the "romgen" utility, from a known good target-pack.
	 *
	 * This file may be regenerated by executing the following
	 * command (redirecting the output), *without* needing any
	 * access to either a MicroConnect or a target board:
	 *
	 * host% romgen --show-comment dummy:mb837stx7108:host
	 *
	 * Where "dummy" need not correspond to any real IP address on
	 * your network.  In addition, note that "mb837stx7108" should
	 * substituted if you have a custom target-pack connect command.
	 *
	 * At the time of writing this (April 2010) the output from "romgen"
	 * needs to be edited slightly.  The edit is just two add two lines
	 * to comment out all the PMB + 32-bit mode configuration. The lines
	 * to comment out start with the pokes that setup the PMB arrays,
	 * and end with pokes that configure the CCN registers.
	 * That is, the following two lines should be added:
	 *		#if 0
	 *		#endif
	 * See the supplied version of the ".romgen" file, to see where
	 * these have been added, if there is any doubt.
	 */
#include "mb837-stx7108.romgen"

	END_MARKER

__memory_setup_table_end:

	.end
