/*
 * The poke table is a series of long words, in the format
 *
 *	opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#define CONFIG_SH_OLD_POKE_LOOP_PARADIGM	/* QQQ - DELETE */


#include "asm/stx7141reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:

	/*
	 * include the appropriate set of "GDB pokes", (usually) generated
	 * using the "romgen" utility, from a known good target-pack.
	 *
	 * This file may be regenerated by connecting your specific board
	 * to an STMC2 (note: currently it must be version 2) and then
	 * executing the following command (redirecting the output):
	 *
	 * host% romgen --target-connect --show-comment <stmc2>:eud7141:estb
	 *
	 * Where "<stmc2>" should be replaced with the IP address
	 * (or the DNS name) of the STMC2 box.  Also the "eud7141" should
	 * substituted if you have a custom target-pack connect command.
	 *
	 * Note: The connect command used with "romgen", should connect
	 * only in 29-bit mode - even if U-Boot will be built for 32-bit mode.
	 * That is, do not use the "seuc=1" (or similar) option with "romgen".
	 */
#include "eud7141.romgen"

#ifdef CONFIG_SH_SE_MODE
	/*
	 * Note that we also manually need to move the LMI0 and LMI1 base addresses to
	 * their 32-bit SE mode locations as defined in the datasheet and change the
	 * 'upper bound addresses' (in row attribute registers) for the LMIs.
	 * For LMI #0, we have 256MiB (UBA = 0x40000000 + 256MiB = 0x50000000).
	 * For LMI #1, we have 128MiB (UBA = 0x80000000 + 128MiB = 0x88000000).
	 */
	UPDATE32(STX7141_SYSCONF_SYS_CFG38, 0xFFFFFF00, 0x00000040)
	UPDATE32(STX7141_SYSCONF_SYS_CFG39, 0xFFFFFF00, 0x00000080)
	UPDATE32(ST40_LMI_SDRA0_0(0), 0x001FFFFF, 0x50000000)
	UPDATE32(ST40_LMI_SDRA1_0(0), 0x001FFFFF, 0x50000000)
	UPDATE32(ST40_LMI_SDRA0_0(1), 0x001FFFFF, 0x88000000)
	UPDATE32(ST40_LMI_SDRA1_0(1), 0x001FFFFF, 0x88000000)
#endif	/* CONFIG_SH_SE_MODE */

	END_MARKER

__memory_setup_table_end:

	.end
